-- Aby móc uruchomić ten przykład, upewnij się najpierw, że 
-- uruchomiłeś wcześniej SalesOrdersStructure.sql i
-- SalesOrdersData.sql w katalogu z bazami przykładowymi 

SET search_path = SalesOrdersSample;

WITH ProdSale AS
  (SELECT OD.ProductNumber,
       SUM(OD.QuantityOrdered * OD.QuotedPrice) AS ProductSales
     FROM Order_Details AS OD
     WHERE OD.ProductNumber IN 
       (SELECT P.ProductNumber
        FROM Products AS P INNER JOIN Categories AS C
          ON P.CategoryID = C.CategoryID
        WHERE C.CategoryDescription = 'Accessories')
     GROUP BY OD.ProductNumber),
RankedCategories AS
  (SELECT Categories.CategoryDescription, Products.ProductName, 
          ProdSale.ProductSales, 
          RANK() OVER (
            ORDER BY ProdSale.ProductSales DESC
          ) AS RankInCategory
   FROM Categories INNER JOIN Products 
     ON Categories.CategoryID = Products.CategoryID
   INNER JOIN ProdSale
     ON ProdSale.ProductNumber = Products.ProductNumber),
ProdCount AS
  (SELECT COUNT(ProductNumber) AS NumProducts 
   FROM ProdSale) 
SELECT P1.CategoryDescription, P1.ProductName, 
    P1.ProductSales, P1.RankInCategory, 
    (CASE WHEN RankInCategory <= ROUND(0.2 * NumProducts, 0)
            THEN 'First' 
          WHEN RankInCategory <= ROUND(0.4 * NumProducts,0)
            THEN 'Drugi' 
          WHEN RankInCategory <= ROUND(0.6 * NumProducts,0)
            THEN 'Trzeci' 
          WHEN RankInCategory <= ROUND(0.8 * NumProducts,0)
            THEN 'Czwarty' 
          ELSE 'Piąty' END) AS Quintile
FROM RankedCategories AS P1 
CROSS JOIN ProdCount
ORDER BY P1.ProductSales DESC;
